

function getKeyCodeFromEvent(evt)
{
	return evt.which;
}

function checkKeyPress(event)
{
	var keycode = getKeyCodeFromEvent(event);
	
	//handle numbers
	if(keycode >= 48 && keycode <= 57)
	{
		AddDigit(""+(keycode-48))
	}
	//handle A-F
	else if(keycode >= 97 && keycode <= 102)
	{
		switch(keycode)
		{
			case 97:
				AddDigit("A");
				break;
			case 98:
				AddDigit("B");
				break;
			case 99:
				if(!event.metaKey)
				{
					AddDigit("C");
				}
				break;
			case 100:
				AddDigit("D");
				break;
			case 101:
				AddDigit("E");
				break;
			case 102:
				AddDigit("F");
				break;
		}
	}
	//special keys
	else
	{
		switch(keycode)
		{
			case 43:
				//+ key
				PileUpOpp('+');
				break;
			case 13:
				//enter
			case 61:
				//equals key
				Equal();
				return false;
				break;
			case 27:
				if(event.metaKey)
				{
					//applekey+esc
					MemoryClear();
				}
				else
				{
					//esc
					Clear(true);
				}
				break;
			case 45:
				//minus
				PileUpOpp('-');
				break;
			case 47:
				//div
				PileUpOpp('/');
				break;
			case 42:
				//times
				PileUpOpp('*');
				break;
			case 8:
				//backspace (and ctrl+h too)
				if(!event.ctrlKey)
				{
					DelDigit();
					return false;
				}
				break;
			case 60:
				//left shift < key
				PileUpOpp('<<');
				break;
			case 62:
				//right shift > key
				PileUpOpp('>>');
				break;
			case 38:
				//and shift+7 (&)
				PileUpOpp('and');
				break;
			case 124:
				//or shift+\ (|)
				PileUpOpp('or');
				break;
			case 33:
				if(event.shiftKey)
				{
					//not shift+1 (!)
					Not();
				}
				break;
			case 95:
				//toggle +/- shift+- (_)
				ChangeSign()
				break;
			case 109:
				//m = memory+ 
				MemoryPlus();
				break;
			case 181:
				//alt+m = memory-
				if(event.altKey)
				{
					MemoryMinus();
				}
				break;
			case 77:
				//shift+m memory recall
				MemoryRestore();
				break;
			case 40:
				//open paren (
				OpenBrackets();
				break;
			case 41:
				//close paren )
				CloseBrackets();
				break;	
		}
		// altKey  altLeft  ctrlKey  ctrlLeft  metaKey  shiftKey  shiftLeft 
		//alert(keycode + " " + event.altKey);
	}
}

document.onkeypress = checkKeyPress;